(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25883,        574]
NotebookOptionsPosition[     25550,        557]
NotebookOutlinePosition[     25905,        573]
CellTagsIndexPosition[     25862,        570]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "NMR", " ", "Spectrum", " ", "with", " ", "Noise", " ", "component"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", "\[IndentingNewLine]", "\t  ", 
     RowBox[{
     "This", " ", "test", " ", "is", " ", "somehow", " ", "chanllenging", " ",
       "for", " ", "the", " ", 
      RowBox[{"computer", ".", "\[IndentingNewLine]", "\t", "Please"}], " ", 
      "be", " ", "patient", " ", "when", " ", "you", " ", "change", " ", 
      "the", " ", "paratmeter", " ", "in", " ", "the", " ", "control", " ", 
      RowBox[{"panel", ".", "\[IndentingNewLine]", "\t", "Especially"}], " ", 
      "when", " ", "you", " ", "set", " ", "a", " ", "high", " ", "value", 
      " ", "for", " ", "transients"}]}], ",", " ", 
    RowBox[{
    "the", " ", "program", " ", "will", " ", "last", " ", "long", " ", "with",
      " ", "every", " ", "changes", " ", "of", " ", "other", " ", 
     "parameters"}]}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "=", 
      RowBox[{"t0", "/", "n"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Column", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<Free Induction Decay\>\"", ",", "\"\<Label\>\"", ",", "15", 
           ",", "Red", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"m", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A1", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "t"}], "/", "T1"}], "]"}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "w1", "*", "t"}], "]"}]}], "+", 
               
               RowBox[{"A2", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "t"}], "/", "T2"}], "]"}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "w2", "*", "t"}], "]"}]}], "+", 
               
               RowBox[{"A3", "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "t"}], "/", "T3"}], "]"}], "*", 
                RowBox[{"Cos", "[", 
                 RowBox[{"2", "*", "Pi", "*", "w3", "*", "t"}], "]"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"An", "*", 
             RowBox[{"Total", "[", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"N", "[", 
                  RowBox[{"RandomReal", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "]"}], 
                 "}"}], ",", 
                RowBox[{"{", "m", "}"}]}], "]"}], "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "t0"}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "t0"}], "}"}], ",", "All"}], "}"}]}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}], ",", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<t (s)\>\"", ",", "16", ",", "Italic"}], "]"}]}], 
           ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"400", ",", "200"}], "}"}]}], ",", 
           RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<Frequency Spectrum\>\"", ",", "\"\<Label\>\"", ",", "15", ",", 
           "Red", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", "A1", 
               "*", "m", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", "*", "Pi", "*", "t", "*", "k", "*", 
                 RowBox[{"(", 
                  RowBox[{"w1", "-", "w"}], ")"}]}], "]"}], "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{"-", "k"}], "*", 
                 RowBox[{"t", "/", "T1"}]}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", 
                RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "+", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", "A2", 
               "*", "m", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", "*", "Pi", "*", "t", "*", "k", "*", 
                 RowBox[{"(", 
                  RowBox[{"w2", "-", "w"}], ")"}]}], "]"}], "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{"-", "k"}], "*", 
                 RowBox[{"t", "/", "T2"}]}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", 
                RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "+", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", "A3", 
               "*", "m", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"2", "*", "Pi", "*", "t", "*", "k", "*", 
                 RowBox[{"(", 
                  RowBox[{"w3", "-", "w"}], ")"}]}], "]"}], "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{"-", "k"}], "*", 
                 RowBox[{"t", "/", "T3"}]}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", 
                RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "+", 
            RowBox[{"An", "*", 
             RowBox[{"Total", "[", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Fourier", "[", 
                 RowBox[{"{", 
                  RowBox[{"N", "[", 
                   RowBox[{"RandomReal", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "]"}], 
                  "}"}], "]"}], ",", 
                RowBox[{"{", "m", "}"}]}], "]"}], "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"w", ",", 
             RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}], ",", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<f (Hz)\>\"", ",", "16", ",", "Italic"}], "]"}]}], 
           ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "All"}], "}"}]}], 
           ",", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"400", ",", "200"}], "}"}]}], ",", 
           RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
       RowBox[{"Spacings", "\[Rule]", "1"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<NMR Signal and Spectrum\>\"", ",", "15", ",", "Blue", ",", "Bold"}],
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<Parameter of Signals\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
     "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", "2", ",", "\"\<Acquition time\>\""}], "}"}], ",", 
      "0", ",", "5", ",", "0.001", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "20", ",", "\"\<Number of data points\>\""}], "}"}], 
      ",", "0", ",", "100", ",", "1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A1", ",", "0.25", ",", "\"\<Amplitude of component I\>\""}], 
       "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A2", ",", "0.25", ",", "\"\<Amplitude of component II\>\""}], 
       "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A3", ",", "0.25", ",", "\"\<Amplitude of component III\>\""}],
        "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w1", ",", "1", ",", "\"\<Frequency of component I\>\""}], 
       "}"}], ",", 
      RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w2", ",", "0.2", ",", "\"\<Frequency of component II\>\""}], 
       "}"}], ",", 
      RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w3", ",", 
        RowBox[{"-", "1"}], ",", "\"\<Frequency of component III\>\""}], 
       "}"}], ",", 
      RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T1", ",", "2", ",", "\"\<T2 relaxation of component I\>\""}], 
       "}"}], ",", "0", ",", "5", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T2", ",", "2", ",", "\"\<T2 relaxation of component II\>\""}],
        "}"}], ",", "0", ",", "5", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "T3", ",", "2", ",", "\"\<T2 relaxation of component III\>\""}], "}"}],
       ",", "0", ",", "5", ",", "0.1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<Parameter of Noise\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
     "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"An", ",", "0.25", ",", "\"\<Amplitude of noise\>\""}], "}"}], 
      ",", "0", ",", "1", ",", "0.01", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<Spectrum Optimization\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
     "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lb", ",", "0", ",", "\"\<Exponential Apodization\>\""}], 
       "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "1", ",", "\"\<Transients\>\""}], "}"}], ",", "1", 
      ",", "64", ",", "1", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.537292566324006*^9, 3.5372925921045027`*^9}, {
   3.537292653355855*^9, 3.537292654258654*^9}, {3.537292744103059*^9, 
   3.537292770052142*^9}, {3.537292801124668*^9, 3.537292886834753*^9}, {
   3.537292977870645*^9, 3.537293055735526*^9}, {3.537293091203423*^9, 
   3.537293354735154*^9}, {3.537293399650724*^9, 3.537293399812518*^9}, 
   3.537293438819229*^9, {3.537293480505747*^9, 3.537293530168413*^9}, {
   3.537293599935392*^9, 3.537293647279003*^9}, {3.537293703511115*^9, 
   3.5372939239226227`*^9}, 3.537294103345327*^9, 3.537294171468026*^9, {
   3.538072706741087*^9, 3.538072801354054*^9}, {3.538073236347074*^9, 
   3.538073277698607*^9}, {3.5380733131752996`*^9, 3.538073318476812*^9}, {
   3.538073580690175*^9, 3.5380735823363247`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`A1$$ = 0.25, $CellContext`A2$$ = 
    0.25, $CellContext`A3$$ = 0.25, $CellContext`An$$ = 
    0.09, $CellContext`lb$$ = 0, $CellContext`m$$ = 1000, $CellContext`n$$ = 
    72, $CellContext`t0$$ = 4.613, $CellContext`T1$$ = 
    0.5, $CellContext`T2$$ = 1.1, $CellContext`T3$$ = 0.9, $CellContext`w1$$ =
     2., $CellContext`w2$$ = -1.5, $CellContext`w3$$ = -0.7, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["NMR Signal and Spectrum", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["Parameter of Signals", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`t0$$], 2, "Acquition time"}, 0, 5, 0.001}, {{
       Hold[$CellContext`n$$], 20, "Number of data points"}, 0, 100, 1}, {{
       Hold[$CellContext`A1$$], 0.25, "Amplitude of component I"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`A2$$], 0.25, "Amplitude of component II"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`A3$$], 0.25, "Amplitude of component III"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`w1$$], 1, "Frequency of component I"}, -2, 2, 0.1}, {{
       Hold[$CellContext`w2$$], 0.2, "Frequency of component II"}, -2, 2, 
      0.1}, {{
       Hold[$CellContext`w3$$], -1, "Frequency of component III"}, -2, 2, 
      0.1}, {{
       Hold[$CellContext`T1$$], 2, "T2 relaxation of component I"}, 0, 5, 
      0.1}, {{
       Hold[$CellContext`T2$$], 2, "T2 relaxation of component II"}, 0, 5, 
      0.1}, {{
       Hold[$CellContext`T3$$], 2, "T2 relaxation of component III"}, 0, 5, 
      0.1}, {
      Hold[
       Style["Parameter of Noise", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`An$$], 0.25, "Amplitude of noise"}, 0, 1, 0.01}, {
      Hold[
       Style["Spectrum Optimization", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`lb$$], 0, "Exponential Apodization"}, 0, 1, 0.01}, {{
      
       Hold[$CellContext`m$$], 1, "Transients"}, 1, 1000, 1}}, 
    Typeset`size$$ = {400., {229.84375, 235.15625}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t0$20464$$ = 0, $CellContext`n$20465$$ = 
    0, $CellContext`A1$20466$$ = 0, $CellContext`A2$20467$$ = 
    0, $CellContext`A3$20468$$ = 0, $CellContext`w1$20469$$ = 
    0, $CellContext`w2$20470$$ = 0, $CellContext`w3$20471$$ = 
    0, $CellContext`T1$20472$$ = 0, $CellContext`T2$20473$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`A1$$ = 0.25, $CellContext`A2$$ = 
        0.25, $CellContext`A3$$ = 0.25, $CellContext`An$$ = 
        0.25, $CellContext`lb$$ = 0, $CellContext`m$$ = 1, $CellContext`n$$ = 
        20, $CellContext`t0$$ = 2, $CellContext`T1$$ = 2, $CellContext`T2$$ = 
        2, $CellContext`T3$$ = 2, $CellContext`w1$$ = 1, $CellContext`w2$$ = 
        0.2, $CellContext`w3$$ = -1}, "ControllerVariables" :> {
        Hold[$CellContext`t0$$, $CellContext`t0$20464$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$20465$$, 0], 
        Hold[$CellContext`A1$$, $CellContext`A1$20466$$, 0], 
        Hold[$CellContext`A2$$, $CellContext`A2$20467$$, 0], 
        Hold[$CellContext`A3$$, $CellContext`A3$20468$$, 0], 
        Hold[$CellContext`w1$$, $CellContext`w1$20469$$, 0], 
        Hold[$CellContext`w2$$, $CellContext`w2$20470$$, 0], 
        Hold[$CellContext`w3$$, $CellContext`w3$20471$$, 0], 
        Hold[$CellContext`T1$$, $CellContext`T1$20472$$, 0], 
        Hold[$CellContext`T2$$, $CellContext`T2$20473$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`t = $CellContext`t0$$/$CellContext`n$$; 
       Column[{
          Style["Free Induction Decay", "Label", 15, Red, Bold], 
          
          Plot[$CellContext`m$$ (($CellContext`A1$$ 
               Exp[(-$CellContext`t)/$CellContext`T1$$]) 
              Cos[((2 Pi) $CellContext`w1$$) $CellContext`t] + \
($CellContext`A2$$ Exp[(-$CellContext`t)/$CellContext`T2$$]) 
              Cos[((2 Pi) $CellContext`w2$$) $CellContext`t] + \
($CellContext`A3$$ Exp[(-$CellContext`t)/$CellContext`T3$$]) 
              Cos[((2 Pi) $CellContext`w3$$) $CellContext`t]) + \
$CellContext`An$$ Total[
              Table[{
                N[
                 RandomReal[{-1, 1}]]}, {$CellContext`m$$}]], {$CellContext`t,
             0, $CellContext`t0$$}, 
           PlotRange -> {{0, $CellContext`t0$$}, All}, Frame -> True, 
           FrameLabel -> Style["t (s)", 16, Italic], PlotStyle -> {Red, 
             AbsoluteThickness[2]}, ImageSize -> {400, 200}, AspectRatio -> 
           0.35], 
          Style["Frequency Spectrum", "Label", 15, Red, Bold], 
          Plot[
          Sum[(((Exp[((-$CellContext`lb$$) $CellContext`k) $CellContext`t] \
$CellContext`A1$$) $CellContext`m$$) 
              Cos[(((2 
                   Pi) $CellContext`t) $CellContext`k) ($CellContext`w1$$ - \
$CellContext`w)]) 
             Exp[(-$CellContext`k) ($CellContext`t/$CellContext`T1$$)], \
{$CellContext`k, 0, $CellContext`n$$ - 1}] + 
           Sum[(((Exp[((-$CellContext`lb$$) $CellContext`k) $CellContext`t] \
$CellContext`A2$$) $CellContext`m$$) 
              Cos[(((2 
                   Pi) $CellContext`t) $CellContext`k) ($CellContext`w2$$ - \
$CellContext`w)]) 
             Exp[(-$CellContext`k) ($CellContext`t/$CellContext`T2$$)], \
{$CellContext`k, 0, $CellContext`n$$ - 1}] + 
           Sum[(((Exp[((-$CellContext`lb$$) $CellContext`k) $CellContext`t] \
$CellContext`A3$$) $CellContext`m$$) 
              Cos[(((2 
                   Pi) $CellContext`t) $CellContext`k) ($CellContext`w3$$ - \
$CellContext`w)]) 
             Exp[(-$CellContext`k) ($CellContext`t/$CellContext`T3$$)], \
{$CellContext`k, 0, $CellContext`n$$ - 1}] + $CellContext`An$$ Total[
              Table[
               Fourier[{
                 N[
                  
                  RandomReal[{-1, 
                   1}]]}], {$CellContext`m$$}]], {$CellContext`w, -2, 2}, 
           Frame -> True, FrameLabel -> Style["f (Hz)", 16, Italic], 
           PlotStyle -> {Red, 
             AbsoluteThickness[2]}, PlotRange -> {{-2, 2}, All}, 
           ImageSize -> {400, 200}, AspectRatio -> 0.35]}, Alignment -> Left, 
         Spacings -> 1]), "Specifications" :> {
        Style["NMR Signal and Spectrum", 15, 
         RGBColor[0, 0, 1], Bold], Delimiter, 
        Style["Parameter of Signals", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`t0$$, 2, "Acquition time"}, 0, 5, 0.001, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`n$$, 20, "Number of data points"}, 0, 100, 1, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A1$$, 0.25, "Amplitude of component I"}, 0, 1,
          0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A2$$, 0.25, "Amplitude of component II"}, 0, 
         1, 0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A3$$, 0.25, "Amplitude of component III"}, 0, 
         1, 0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w1$$, 1, "Frequency of component I"}, -2, 2, 
         0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w2$$, 0.2, "Frequency of component II"}, -2, 
         2, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w3$$, -1, "Frequency of component III"}, -2, 
         2, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T1$$, 2, "T2 relaxation of component I"}, 0, 
         5, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T2$$, 2, "T2 relaxation of component II"}, 0, 
         5, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T3$$, 2, "T2 relaxation of component III"}, 0,
          5, 0.1, Appearance -> "Labeled", ImageSize -> Small}, Delimiter, 
        Style["Parameter of Noise", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`An$$, 0.25, "Amplitude of noise"}, 0, 1, 
         0.01, Appearance -> "Labeled", ImageSize -> Small}, Delimiter, 
        Style["Spectrum Optimization", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`lb$$, 0, "Exponential Apodization"}, 0, 1, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`m$$, 1, "Transients"}, 1, 1000, 1, Appearance -> 
         "Labeled", ImageSize -> Small}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{734., {257., 262.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5372926556351843`*^9, {3.5372927521634703`*^9, 3.537292772993586*^9}, 
   3.537292847035275*^9, 3.5372932503008327`*^9, {3.537293357114942*^9, 
   3.537293400878128*^9}, 3.53729344466251*^9, {3.537293481519372*^9, 
   3.537293531306966*^9}, 3.537293648451214*^9, 3.537293937370928*^9, 
   3.53729410522046*^9, 3.538072731226363*^9, 3.538073218560349*^9, 
   3.538073279670883*^9, 3.538073328288555*^9}]
}, Open  ]]
},
WindowSize->{1280, 683},
WindowMargins->{{11, Automatic}, {Automatic, 1}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 15060, 346, 838, "Input"],
Cell[15642, 370, 9892, 184, 536, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
